<?php

use Bongo\Post\Models\PostCategory;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStickyHeaderColumnToPostCategoriesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('post_categories', 'sticky_header')) {
            Schema::table('post_categories', function (Blueprint $table) {
                $table->tinyInteger('sticky_header')
                    ->default(PostCategory::ENABLED)
                    ->after('transparent_header');
            });
        }
    }

    public function down()
    {
        Schema::table('post_categories', function (Blueprint $table) {
            $table->dropColumn('sticky_header');
        });
    }
}
