<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('posts', 'schema')) {
            Schema::table('posts', function (Blueprint $table) {
                $table->mediumText('schema')
                    ->nullable()
                    ->after('js');
            });
        }
    }

    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropColumn('schema');
        });
    }
};
