<?php

namespace Bongo\Post\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\CoverImage;
use Bongo\Post\Models\PostCategory;
use Exception;
use Illuminate\Http\JsonResponse;

class PostCategoryImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, PostCategory $postCategory): JsonResponse
    {
        $files = request()->file('files');

        try {
            $postCategory = (new CoverImage($postCategory, $files[0]))->save();

            return response()->json([$postCategory->getPrimaryImage(['preset' => 'thumb'])]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
