<?php

namespace Bongo\Post\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Post\Http\Resources\PostResource;
use Bongo\Post\Models\Post;
use Illuminate\Database\Eloquent\Builder;

class PostDatatableController extends AbstractDatatableController
{
    protected Post $post;

    public function __construct(Post $post)
    {
        $this->post = $post;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->post->newQuery();
    }

    protected function setResults()
    {
        $this->results = PostResource::collection($this->query->distinct()->get());
    }
}
