<?php

namespace Bongo\Post\Http\Controllers\Frontend;

use Bongo\Framework\Helpers\File;
use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Models\Image;
use Bongo\Image\Services\BuilderService;
use Bongo\Post\Events\PostUpdated;
use Bongo\Post\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;

class PostController extends AbstractController
{
    public function index()
    {
        return redirect()->route('frontend.post_category.index');
    }

    public function show($slug)
    {
        $post = Post::where('slug', '=', $slug)->first();
        if (! $post || (! $post->isActive() && ! auth()->user())) {
            abort('404', 'Post could not be found');
        }

        // Set the selected category for related
        if (! Session::has('selected_post_category') && $primaryCategory = $post->getPrimaryCategory()) {
            Session::put('selected_post_category', $primaryCategory);
        }

        return view('post::frontend.show', compact('post'));
    }

    public function edit($uuid)
    {
        if (! $post = Post::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        return view('post::frontend.builder', compact('post'));
    }

    public function image(Request $request, $uuid)
    {
        if (! $post = Post::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        $file = $request->file('fileImage');
        $ext = $file->getClientOriginalExtension();
        $name = rtrim($file->getClientOriginalName(), $ext);
        $fileName = File::generateName($name, $ext);

        $filePath = config('image.public_path').'posts/'.$post->id.'/';

        if ($file->storePubliclyAs($filePath, $fileName)) {

            // Save the image to the database
            $image = new Image();
            $image->name = $fileName;
            $image->title = $post->name;
            $image->path = $filePath;
            $image->type = Image::WYSIWYG;
            $image->ext = $ext;
            $image->created_by = user() ? user()->id : null;
            $image->updated_by = user() ? user()->id : null;
            $post->images()->save($image);

            // Return the link to the file
            $fileLink = Storage::url($filePath.$fileName);

            return "<html><body onload=\"parent.applyLargerImage('".$fileLink."')\"></body></html>";
        }

        return "<html><body onload=\"alert('Sorry, your file was not uploaded.')\"></body></html>";
    }

    public function update(Request $request, $uuid)
    {
        if (! $post = Post::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        // Get the html
        $post->content = $request->get('html');

        // Process any images then save
        $builderService = new BuilderService($post, '/posts/');
        $post->content = $builderService->process();
        $post->save();

        event(new PostUpdated($post));

        return redirect()
            ->route('frontend.post.edit', $post->uuid)
            ->success(trans('post::backend.update_success'));
    }
}
