<?php

namespace Bongo\Post\Http\Requests;

use Bongo\Post\Models\Post;
use Illuminate\Foundation\Http\FormRequest;

class StorePostRequest extends FormRequest
{
    public function rules(): array
    {
        $postTable = (new Post())->getTable();

        return [
            'name' => "required|unique:{$postTable},slug,NULL,id,deleted_at,NULL|max:75",
        ];
    }
}
