<?php

namespace Bongo\Post\Http\Requests;

use Bongo\Post\Models\Post;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePostRequest extends FormRequest
{
    public function rules(): array
    {
        $postTable = (new Post())->getTable();

        return [
            'name' => "required|unique:{$postTable},slug,{$this->post->id},id,deleted_at,NULL|max:75",
        ];
    }
}
