<?php

namespace Bongo\Post\Http\ViewComposers;

use Bongo\Post\Models\PostCategory;
use Illuminate\View\View;

class PostCategoryComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the post categories
        $postCategories = PostCategory::active()->orderBy('name', 'ASC')->pluck('name', 'id');
        if (! $postCategories) {
            $postCategories = [];
        }

        // Pass the data to the view partial
        $view->with(compact('postCategories'));
    }
}
