<?php

namespace Bongo\Post\Http\ViewComposers;

use Bongo\Post\Models\Post;
use Illuminate\View\View;

class PostComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the posts
        $posts = Post::active()->orderBy('name', 'ASC')->pluck('name', 'id');
        if (! $posts) {
            $posts = [];
        }

        // Pass the data to the view partial
        $view->with(compact('posts'));
    }
}
