<?php

use Bongo\Post\Models\Post;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStickyHeaderColumnToPostsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('posts', 'sticky_header')) {
            Schema::table('posts', function (Blueprint $table) {
                $table->tinyInteger('sticky_header')
                    ->default(Post::ENABLED)
                    ->after('transparent_header');
            });
        }
    }

    public function down()
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropColumn('sticky_header');
        });
    }
}
