<?php

use Bongo\Post\Http\Controllers\Backend\PostCategoryController;
use Bongo\Post\Http\Controllers\Backend\PostCategoryDatatableController;
use Bongo\Post\Http\Controllers\Backend\PostCategoryImageController;
use Bongo\Post\Http\Controllers\Backend\PostController;
use Bongo\Post\Http\Controllers\Backend\PostDatatableController;
use Bongo\Post\Http\Controllers\Backend\PostImageController;
use Illuminate\Support\Facades\Route;

Route::as('post.')
    ->prefix(config('post.prefix'))
    ->group(function () {

        Route::get('/', [PostController::class, 'index'])
            ->name('index');

        Route::get('create', [PostController::class, 'create'])
            ->name('create');

        Route::post('store', [PostController::class, 'store'])
            ->name('store');

        Route::get('datatable', [PostDatatableController::class, 'index'])
            ->name('datatable');

        // Post/{post}/
        Route::prefix('{post}')
            ->group(function () {

                Route::get('/', [PostController::class, 'show'])
                    ->name('show');

                Route::get('edit', [PostController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [PostController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [PostController::class, 'destroy'])
                    ->name('destroy');

                Route::get('duplicate', [PostController::class, 'duplicate'])
                    ->name('duplicate');

                Route::post('image', [PostImageController::class, 'upload'])
                    ->name('image');
            });
    });

// post-categories
Route::as('post_category.')
    ->prefix(config('post.category_prefix'))
    ->group(function () {

        Route::get('/', [PostCategoryController::class, 'index'])
            ->name('index');

        Route::get('create', [PostCategoryController::class, 'create'])
            ->name('create');

        Route::post('store', [PostCategoryController::class, 'store'])
            ->name('store');

        Route::get('datatable', [PostCategoryDatatableController::class, 'index'])
            ->name('datatable');

        // category/{postCategory}/
        Route::prefix('{postCategory}')
            ->group(function () {

                Route::get('/', [PostCategoryController::class, 'show'])
                    ->name('show');

                Route::get('edit', [PostCategoryController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [PostCategoryController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [PostCategoryController::class, 'destroy'])
                    ->name('destroy');

                Route::post('image', [PostCategoryImageController::class, 'upload'])
                    ->name('image');
            });
    });
