<?php

use Bongo\Post\Http\Controllers\Frontend\PostBackgroundImageController;
use Bongo\Post\Http\Controllers\Frontend\PostCategoryController;
use Bongo\Post\Http\Controllers\Frontend\PostController;
use Bongo\Post\Http\Controllers\Frontend\PostImageController;
use Illuminate\Support\Facades\Route;

Route::as('post.')
    ->prefix(config('post.prefix'))
    ->group(function () {

        // Builder
        Route::get('edit/{uuid}', [PostController::class, 'edit'])
            ->middleware(['auth', 'employee'])
            ->name('edit');

        Route::post('update/{uuid}', [PostController::class, 'update'])
            ->middleware(['auth', 'employee'])
            ->name('update');

        Route::post('image/{uuid}', [PostImageController::class, 'upload'])
            ->name('image');

        Route::post('background/{uuid}', [PostBackgroundImageController::class, 'upload'])
            ->name('background_image');

        // Public
        Route::get('{slug}', [PostController::class, 'show'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('show');

        Route::get('/', [PostController::class, 'index'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('index');
    });

// post-categories
Route::as('post_category.')
    ->prefix(config('post.category_prefix'))
    ->group(function () {

        Route::get('{slug}', [PostCategoryController::class, 'show'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('show');

        Route::get('/', [PostCategoryController::class, 'index'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('index');
    });
