@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $postCategory->name }}
        @slot('actions')
            @linkButton(['name' => trans('post::backend.category_show'),'url' => route('frontend.post_category.show', $postCategory->slug),'target' => '_blank'])
            @deleteButton(['class' => 'btn-danger mr-2', 'permission' => 'post_category.delete', 'name' => trans('post::backend.category_delete'), 'url' => route('backend.post_category.destroy', $postCategory->id)])
            @backButton(['name' => trans('post::backend.category_index'), 'url' => route('backend.post_category.index')])
            @editButton(['permission' => 'post_category.update', 'name' => trans('post::backend.category_edit'), 'url' => route('backend.post_category.edit', $postCategory->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $postCategory->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($postCategory->status) ? ucwords($postCategory->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Canonical Url', 'value' => $postCategory->meta_canonical])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Indexing',
                                'value' => ! empty($postCategory->meta_index) ? ucwords($postCategory->meta_index) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Transparent Header',
                                'value' => ! empty($postCategory->transparent_header) ? ucwords($postCategory->transparent_header) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Sticky Header',
                                'value' => ! empty($postCategory->sticky_header) ? ucwords($postCategory->sticky_header) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Slug', 'value' => $postCategory->slug])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Title', 'value' => $postCategory->meta_title])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Description', 'value' => $postCategory->meta_description])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @label(['name' => 'Posts'])
                            <div class="mt-1 text-sm leading-5 text-gray-900 {{ $class ?? '' }}">
                                @if (isset($postCategory->posts) && count($postCategory->posts))
                                    @foreach ($postCategory->posts as $post)
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-100 text-gray-800">
                                            {{ $post->name }}
                                        </span>
                                    @endforeach
                                @else
                                    -- --
                                @endif
                            </div>
                        </div>
                        <div class="sm:col-span-1">
                            @label(['name' => 'Cover / OG Image'])
                            <img
                                class="img-fluid mx-auto d-block w-100"
                                src="{{ $postCategory->getPrimaryImage(['preset' => 'large']) }}"
                                alt="{{ $postCategory->name }}"
                            />
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Content', 'value' => $postCategory->content, 'isHtml' => true])
                @endcomponent
            </div>
        </section>
    @endcomponent

@stop
