@extends('framework::frontend.layouts.app')

@section('meta_title', $postCategory->meta_title)
@section('meta_description', $postCategory->meta_description)
@section('meta_index', $postCategory->meta_index)
@section('meta_canonical', $postCategory->meta_canonical)
@section('meta_image', asset($postCategory->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForPost($postCategory) !!}@endsection

@section('header_class', $postCategory->getHeaderClass())
@section('page_css', $postCategory->css)
@section('page_javascript')
    {!! $postCategory->js !!}
@endsection

@section('content')
    <div class="container py-4">
        <div class="row">
            <div class="col">
                <div class="blog-posts">

                    @if(!empty($postCategory->content))
                        <div class="row mb-4">
                            <div class="col">
                                {!! $postCategory->content !!}
                            </div>
                        </div>
                    @endif

                    @if (isset($posts) && count($posts) > 0)
                        <div class="row">
                            @foreach($posts as $key => $post)
                                @include('post::frontend.partials.post')
                            @endforeach
                        </div>
                        {{ $posts->links('framework::frontend.layouts.partials.pagination') }}
                    @endif

                </div>
            </div>
        </div>
    </div>
@stop
