@php($relatedPosts = $post->getRelatedByRandom())

@if($relatedPosts && count($relatedPosts))
    <section class="related-posts pt-5 pb-5">
        <div class="container">

            <h2 class="text-md-center mb-5">
                Related Posts
            </h2>

            <div class="row">
                @foreach($relatedPosts as $relatedPost)
                    <div class="col-md-6 col-lg-3">

                        <article class="related-post card mb-4 lg-md-0">

                            <div class="card-img-top">
                                <a class="d-block" href="{{ route('frontend.post.show', $relatedPost->slug) }}">
                                    <img
                                        class="img-fluid mx-auto d-block w-100"
                                        src="{{ $relatedPost->getPrimaryImage(['preset' => 'small']) }}"
                                        alt="{{ $relatedPost->name }}"
                                    />
                                </a>
                            </div>

                            <div class="card-body">
                                <h5 class="card-title">
                                    <a class="card-link" href="{{ route('frontend.post.show', $relatedPost->slug) }}">
                                        {{ $relatedPost->name }}
                                    </a>
                                </h5>
                            </div>

                        </article>

                    </div>
                @endforeach
            </div>

        </div>
    </section>
@endif
