@extends('framework::frontend.layouts.app')

@section('meta_title', $post->meta_title)
@section('meta_description', $post->meta_description)
@section('meta_index', $post->meta_index)
@section('meta_canonical', $post->meta_canonical)
@section('meta_image', asset($post->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForPost($post) !!}@endsection

@section('header_class', $post->getHeaderClass())
@section('page_css', $post->css)
@section('page_javascript')
    {!! $post->js !!}
@endsection

@section('admin_menu_actions')
    <li class="nav-item">
        <a href="{{ route('frontend.post.edit', $post->uuid) }}">
            <i class="fas fa-external-link-alt" style="top: 0;"></i>
            Post Builder
        </a>
    </li>
@endsection

@section('content')
    <div class="is-wrapper">
        {!! $post->content_clean !!}

        @if(setting('package::post.related_type') == 'next_previous' || setting('package::post.related_type') == 'random_next_previous')
            @include('post::frontend.partials.next_previous')
        @endif

        @if(setting('package::post.related_type') == 'random' || setting('package::post.related_type') == 'random_next_previous')
            @include('post::frontend.partials.related_posts')
        @endif
    </div>
@stop
