<?php

namespace Bongo\Post\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Post\Http\Resources\PostCategoryResource;
use Bongo\Post\Models\PostCategory;
use Illuminate\Database\Eloquent\Builder;

class PostCategoryDatatableController extends AbstractDatatableController
{
    protected PostCategory $postCategory;

    public function __construct(PostCategory $postCategory)
    {
        $this->postCategory = $postCategory;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->postCategory->newQuery();
    }

    protected function setResults()
    {
        $this->results = PostCategoryResource::collection($this->query->distinct()->get());
    }
}
