<?php

namespace Bongo\Post\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\CoverImage;
use Bongo\Post\Models\Post;
use Exception;
use Illuminate\Http\JsonResponse;

class PostImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, Post $post): JsonResponse
    {
        $files = request()->file('files');

        try {
            $post = (new CoverImage($post, $files[0]))->save();

            return response()->json([$post->getPrimaryImage(['preset' => 'thumb'])]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
