<?php

namespace Bongo\Post\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Post\Models\PostCategory;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;

class PostCategoryController extends AbstractController
{
    public function index(): View
    {
        $postCategories = PostCategory::with('images')
            ->active()
            ->paginate(6);

        return view('post::frontend.category.index', compact('postCategories'));
    }

    public function show($slug): View
    {
        $postCategory = PostCategory::where('slug', '=', $slug)->first();
        if (! $postCategory || (! $postCategory->isActive() && ! auth()->user())) {
            abort('404', 'Post category could not be found');
        }

        // Set the selected category
        Session::put('selected_post_category', $postCategory);

        $posts = $postCategory
            ->posts()
            ->active()
            ->latest('date')
            ->with('images')
            ->paginate(6);

        return view('post::frontend.category.show', compact('postCategory', 'posts'));
    }
}
