<?php

namespace Bongo\Post\Http\Requests;

use Bongo\Post\Models\PostCategory;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePostCategoryRequest extends FormRequest
{
    public function rules(): array
    {
        $postCategoryTable = (new PostCategory())->getTable();

        return [
            'name' => "required|unique:{$postCategoryTable},slug,{$this->postCategory->id},id,deleted_at,NULL|max:75",
        ];
    }
}
