<?php

use Bongo\Post\Models\Post;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTransparentHeaderColumnToPostsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('posts', 'transparent_header')) {
            Schema::table('posts', function (Blueprint $table) {
                $table->tinyInteger('transparent_header')
                    ->default(Post::ENABLED)
                    ->after('status');
            });
        }
    }

    public function down()
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropColumn('transparent_header');
        });
    }
}
