@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.post.update', $post) }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('post::backend.edit') }}
            @slot('actions')
                @if(user()->isDeveloper())
                    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
                        <js-editor-button></js-editor-button>
                    </span>
                    <span class="mb-2 mr-3 md:mb-0 lg:mr-0 lg:ml-3 inline-flex rounded-sm shadow-sm">
                        <css-editor-button></css-editor-button>
                    </span>
                @endif
                @backButton(['name' => trans('post::backend.index'), 'url' => route('backend.post.index')])
                @saveButton(['permission' => 'post.update', 'name' => trans('post::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('post::backend.partials.form.details')
        @endcomponent

    </form>
@stop
