<section class="md:grid md:grid-cols-2 md:gap-6">

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input(['name' => 'name', 'value' => $post->name, 'placeholder' => 'About Our Business', 'required'
                    => 'true'])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $post->status,
                        'options' => get_enum_values('posts', 'status')
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'label' => 'Canonical Url',
                        'name' => 'meta_canonical',
                        'value' => $post->meta_canonical,
                        'placeholder' => url()->to('/') . '/about-our-business'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Indexing',
                        'name' => 'meta_index',
                        'value' => $post->meta_index,
                        'options' => [
                            'index' => 'Index Page',
                            'noindex' => 'Dont Index Page'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Transparent Header',
                        'name' => 'transparent_header',
                        'value' => $post->transparent_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Sticky Header',
                        'name' => 'sticky_header',
                        'value' => $post->sticky_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                    'label' => 'Slug',
                    'name' => 'slug',
                    'value' => $post->slug,
                    'placeholder' => 'about-our-business',
                    'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                    'name' => 'meta_title',
                    'value' => $post->meta_title,
                    'placeholder' => 'About Our Business',
                    'maxlength' => 75,
                    ])
                </div>
                <div class="sm:col-span-2">
                    @textarea([
                    'name' => 'meta_description',
                    'value' => $post->meta_description,
                    'placeholder' => 'Everything you ever wanted to know about our business',
                    'maxlength' => 150,
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @include('post::backend.category.partials.dropdowns.category', ['model' => $post])
                </div>
                @if (!empty($post->id))
                    <div class="sm:col-span-1">
                        @label(['name' => 'Cover / OG Image'])
                        <file-uploader
                            class="mt-2"
                            url="{{ route('backend.post.image', $post->id) }}"
                            name="cover_image"
                            height="100"
                        ></file-uploader>
                    </div>
                @endif
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @wysiwyg(['name' => 'summary', 'value' => $post->summary, 'height' => 300, 'placeholder' => 'Enter summary text
        here...'])
    </div>

</section>

<css-editor css="{{ $post->css }}"></css-editor>
<js-editor js="{{ $post->js }}"></js-editor>
