<?php

namespace Bongo\Profile\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\User\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends AbstractController
{
    public function index()
    {
        return view('profile::backend.index', ['user' => user()]);
    }

    public function edit()
    {
        return view('profile::backend.edit', ['user' => user()]);
    }

    public function update(Request $request)
    {
        $userTable = (new User())->getTable();

        // Validate their request
        $request->validate([
            'first_name' => 'nullable|max:70',
            'last_name' => 'nullable|max:70',
            'telephone' => 'nullable',
            'mobile' => 'nullable',
            'email' => "required|string|email:rfc,dns|unique:{$userTable},email,".user()->id.',id,deleted_at,NULL|max:50',
            'password' => 'sometimes|nullable|string|min:8|confirmed|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
        ]);

        // Update their details
        user()->fill($request->except(['password']));
        if ($request->has('password') && ! empty($request->get('password'))) {
            user()->password = Hash::make($request->get('password'));
        }
        user()->save();

        return redirect()
            ->route('backend.profile.index')
            ->success(trans('profile::backend.update_success'));
    }
}
