<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input(['name' => 'first_name', 'value' => $user->first_name])
                </div>
                <div class="sm:col-span-1">
                    @input(['name' => 'last_name', 'value' => $user->last_name])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input(['name' => 'telephone', 'value' => $user->telephone])
                </div>
                <div class="sm:col-span-1">
                    @input(['name' => 'mobile', 'value' => $user->mobile])
                </div>
                <div class="sm:col-span-1">
                    @input(['name' => 'email', 'value' => $user->email, 'required' => 'true'])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @if (!empty($user->id))
            @component('blade::card')
                @label(['name' => 'User Image / Seller Logo'])
                <file-uploader
                    class="mt-2"
                    url="{{ route('backend.profile.image') }}"
                    name="user_avatar"
                    height="100"
                ></file-uploader>
            @endcomponent
        @endif
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">

                <div class="sm:col-span-1">
                    @input(['label' => 'New Password', 'type' => 'password', 'name' => 'password', 'value' => null, ])
                </div>
                <div class="sm:col-span-1">
                    @input(['label' => 'Confirm Password', 'type' => 'password', 'name' => 'password_confirmation',
                    'value' => null])
                </div>

                <div class="sm:col-span-2 text-xs text-gray-400">
                    Your password must be more than 8 characters long,
                    should contain at-least 1 Uppercase, 1 Lowercase,
                    1 Numeric and 1 special character.
                </div>

            </div>
        @endcomponent
    </div>

</section>
