<?php

namespace Bongo\Project\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Project\Http\Resources\ProjectCategoryResource;
use Bongo\Project\Models\ProjectCategory;
use Illuminate\Database\Eloquent\Builder;

class ProjectCategoryDatatableController extends AbstractDatatableController
{
    protected ProjectCategory $projectCategory;

    public function __construct(ProjectCategory $projectCategory)
    {
        $this->projectCategory = $projectCategory;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->projectCategory->newQuery();
    }

    protected function setResults()
    {
        $this->results = ProjectCategoryResource::collection($this->query->distinct()->get());
    }
}
