<?php

namespace Bongo\Project\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Project\Http\Resources\ProjectResource;
use Bongo\Project\Models\Project;
use Illuminate\Database\Eloquent\Builder;

class ProjectDatatableController extends AbstractDatatableController
{
    protected Project $project;

    public function __construct(Project $project)
    {
        $this->project = $project;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->project->newQuery();
    }

    protected function setResults()
    {
        $this->results = ProjectResource::collection($this->query->distinct()->get());
    }
}
