<?php

namespace Bongo\Project\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Project\Models\ProjectCategory;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;

class ProjectCategoryController extends AbstractController
{
    public function index(): View
    {
        $projectCategories = ProjectCategory::with('images')
            ->active()
            ->paginate(6);

        return view('project::frontend.category.index', compact('projectCategories'));
    }

    public function show($slug): View
    {
        $projectCategory = ProjectCategory::where('slug', '=', $slug)->first();
        if (! $projectCategory || (! $projectCategory->isActive() && ! auth()->user())) {
            abort('404', 'Project category could not be found');
        }

        // Set the selected category
        Session::put('selected_project_category', $projectCategory);

        $projects = $projectCategory
            ->projects()
            ->active()
            ->latest('date')
            ->with('images')
            ->paginate(6);

        return view('project::frontend.category.show', compact('projectCategory', 'projects'));
    }
}
