<?php

namespace Bongo\Project\Http\Requests;

use Bongo\Project\Models\ProjectCategory;
use Illuminate\Foundation\Http\FormRequest;

class StoreProjectCategoryRequest extends FormRequest
{
    public function rules(): array
    {
        $projectCategoryTable = (new ProjectCategory())->getTable();

        return [
            'name' => "required|unique:{$projectCategoryTable},slug,NULL,id,deleted_at,NULL|max:75",
        ];
    }
}
