<?php

namespace Bongo\Project\Http\ViewComposers;

use Bongo\Project\Models\Project;
use Illuminate\View\View;

class ProjectComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the projects
        $projects = Project::active()->orderBy('name', 'ASC')->pluck('name', 'id');
        if (! $projects) {
            $projects = [];
        }

        // Pass the data to the view partial
        $view->with(compact('projects'));
    }
}
