<?php

use Illuminate\Database\Migrations\Migration;

class ChangeProjectStickyHeaderColumnToEnum extends Migration
{
    public function up(): void
    {
        DB::statement("
            ALTER TABLE `projects`
            CHANGE COLUMN `sticky_header`
            `sticky_header` ENUM('default', 'enabled', 'disabled')
            DEFAULT 'default'
        ");
    }

    public function down(): void
    {
        DB::statement("
            ALTER TABLE `projects`
            CHANGE COLUMN `sticky_header`
            `sticky_header` TINYINT(1)
            DEFAULT 1
        ");
    }
}
