<?php

use Bongo\Project\Http\Controllers\Backend\ProjectCategoryController;
use Bongo\Project\Http\Controllers\Backend\ProjectCategoryDatatableController;
use Bongo\Project\Http\Controllers\Backend\ProjectCategoryImageController;
use Bongo\Project\Http\Controllers\Backend\ProjectController;
use Bongo\Project\Http\Controllers\Backend\ProjectDatatableController;
use Bongo\Project\Http\Controllers\Backend\ProjectImageController;
use Illuminate\Support\Facades\Route;

// projects
Route::as('project.')
    ->prefix(config('project.prefix'))
    ->group(function () {

        Route::get('/', [ProjectController::class, 'index'])
            ->name('index');

        Route::get('create', [ProjectController::class, 'create'])
            ->name('create');

        Route::post('store', [ProjectController::class, 'store'])
            ->name('store');

        Route::get('datatable', [ProjectDatatableController::class, 'index'])
            ->name('datatable');

        // Project/{project}/
        Route::prefix('{project}')
            ->group(function () {

                Route::get('/', [ProjectController::class, 'show'])
                    ->name('show');

                Route::get('edit', [ProjectController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [ProjectController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [ProjectController::class, 'destroy'])
                    ->name('destroy');

                Route::get('duplicate', [ProjectController::class, 'duplicate'])
                    ->name('duplicate');

                Route::post('image', [ProjectImageController::class, 'upload'])
                    ->name('image');
            });
    });

// project-categories
Route::as('project_category.')
    ->prefix(config('project.category_prefix'))
    ->group(function () {

        Route::get('/', [ProjectCategoryController::class, 'index'])
            ->name('index');

        Route::get('create', [ProjectCategoryController::class, 'create'])
            ->name('create');

        Route::post('store', [ProjectCategoryController::class, 'store'])
            ->name('store');

        Route::get('datatable', [ProjectCategoryDatatableController::class, 'index'])
            ->name('datatable');

        // category/{projectCategory}/
        Route::prefix('{projectCategory}')
            ->group(function () {

                Route::get('/', [ProjectCategoryController::class, 'show'])
                    ->name('show');

                Route::get('edit', [ProjectCategoryController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [ProjectCategoryController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [ProjectCategoryController::class, 'destroy'])
                    ->name('destroy');

                Route::post('image', [ProjectCategoryImageController::class, 'upload'])
                    ->name('image');
            });
    });
