<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $projectCategory->name,
                        'placeholder' => 'About Our Business',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $projectCategory->status,
                        'options' => get_enum_values('project_categories', 'status')
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'label' => 'Canonical Url',
                        'name' => 'meta_canonical',
                        'value' => $projectCategory->meta_canonical,
                        'placeholder' => url()->to('/') . '/about-our-business'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Indexing',
                        'name' => 'meta_index',
                        'value' => $projectCategory->meta_index,
                        'options' => [
                            'index' => 'Index Page',
                            'noindex' => 'Dont Index Page'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Transparent Header',
                        'name' => 'transparent_header',
                        'value' => $projectCategory->transparent_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Sticky Header',
                        'name' => 'sticky_header',
                        'value' => $projectCategory->sticky_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @include('project::backend.partials.dropdowns.project', ['model' => $projectCategory])
                </div>
                @if (!empty($projectCategory->id))
                    <div class="sm:col-span-1">
                        @label(['name' => 'Cover / OG Image'])
                        <file-uploader
                            class="mt-2"
                            url="{{ route('backend.project_category.image', $projectCategory->id) }}"
                            name="cover_image"
                            height="100"
                        ></file-uploader>
                    </div>
                @endif
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                    'label' => 'Slug',
                    'name' => 'slug',
                    'value' => $projectCategory->slug,
                    'placeholder' => 'about-our-business',
                    'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                    'name' => 'meta_title',
                    'value' => $projectCategory->meta_title,
                    'placeholder' => 'About Our Business',
                    'maxlength' => 75,
                    ])
                </div>
                <div class="sm:col-span-2">
                    @textarea([
                    'name' => 'meta_description',
                    'value' => $projectCategory->meta_description,
                    'placeholder' => 'Everything you ever wanted to know about our business',
                    'maxlength' => 150,
                    ])
                </div>
            </div>
        @endcomponent

        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-2">
                    @textarea([
                    'name' => 'content',
                    'value' => $projectCategory->content,
                    'placeholder' => 'We hope you like this category'
                    ])
                </div>
            </div>
        @endcomponent
    </div>
</section>
