@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $projectCategory->name }}
        @slot('actions')
            @linkButton(['name' => trans('project::backend.category_show'),'url' => route('frontend.project_category.show', $projectCategory->slug),'target' => '_blank'])
            @deleteButton(['class' => 'btn-danger mr-2', 'name' => trans('project::backend.category_delete'), 'url' => route('backend.project_category.destroy', $projectCategory->id)])
            @backButton(['name' => trans('project::backend.category_index'), 'url' => route('backend.project_category.index')])
            @editButton(['name' => trans('project::backend.category_edit'), 'url' => route('backend.project_category.edit', $projectCategory->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $projectCategory->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($projectCategory->status) ? ucwords($projectCategory->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Canonical Url', 'value' => $projectCategory->meta_canonical])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Indexing',
                                'value' => ! empty($projectCategory->meta_index) ? ucwords($projectCategory->meta_index) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Transparent Header',
                                'value' => ! empty($projectCategory->transparent_header) ? ucwords($projectCategory->transparent_header) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Sticky Header',
                                'value' => ! empty($projectCategory->sticky_header) ? ucwords($projectCategory->sticky_header) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Slug', 'value' => $projectCategory->slug])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Title', 'value' => $projectCategory->meta_title])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Description', 'value' => $projectCategory->meta_description])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @label(['name' => 'Projects'])
                            <div class="mt-1 text-sm leading-5 text-gray-900 {{ $class ?? '' }}">
                                @if (isset($projectCategory->projects) && count($projectCategory->projects))
                                    @foreach ($projectCategory->projects as $project)
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-100 text-gray-800">
                                            {{ $project->name }}
                                        </span>
                                    @endforeach
                                @else
                                    -- --
                                @endif
                            </div>
                        </div>
                        <div class="sm:col-span-1">
                            @label(['name' => 'Cover / OG Image'])
                            <img
                                class="img-fluid mx-auto d-block w-100"
                                src="{{ $projectCategory->getPrimaryImage(['preset' => 'large']) }}"
                                alt="{{ $projectCategory->name }}"
                            />
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Content', 'value' => $projectCategory->content, 'isHtml' => true])
                @endcomponent
            </div>
        </section>
    @endcomponent

@stop
