@extends('framework::frontend.layouts.app')

@section('meta_title', $project->meta_title)
@section('meta_description', $project->meta_description)
@section('meta_index', $project->meta_index)
@section('meta_canonical', $project->meta_canonical)
@section('meta_image', asset($project->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForProject($project) !!}@endsection

@section('header_class', $project->getHeaderClass())
@section('page_css', $project->css)
@section('page_javascript')
    {!! $project->js !!}
@endsection

@section('admin_menu_actions')
    <li class="nav-item">
        <a href="{{ route('frontend.project.edit', $project->uuid) }}">
            <i class="fas fa-external-link-alt" style="top: 0;"></i>
            Project Builder
        </a>
    </li>
@endsection

@section('content')
    <div class="is-wrapper">

        {!! $project->content_clean !!}

        @if(setting('package::project.related_type') == 'next_previous' || setting('package::project.related_type') == 'random_next_previous')
            @include('project::frontend.partials.next_previous')
        @endif

        @if(setting('package::project.related_type') == 'random' || setting('package::project.related_type') == 'random_next_previous')
            @include('project::frontend.partials.related_projects')
        @endif
    </div>
@stop
