<?php

namespace Bongo\Project\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\CoverImage;
use Bongo\Project\Models\Project;
use Exception;
use Illuminate\Http\JsonResponse;

class ProjectImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, Project $project): JsonResponse
    {
        $files = request()->file('files');

        try {
            $project = (new CoverImage($project, $files[0]))->save();

            return response()->json([$project->getPrimaryImage(['preset' => 'thumb'])]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
