<?php

namespace Bongo\Project\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Services\WysiwygImage;
use Bongo\Project\Models\Project;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ProjectImageController extends AbstractController
{
    public function upload(Request $request, $uuid): string
    {
        // Find the project or fail
        if (! $project = Project::where('uuid', '=', $uuid)->first()) {
            abort('404');
        }

        // Validate that this is an image or fail
        $validator = Validator::make($request->all(), ['fileImage' => 'image|max:4096']);
        if ($validator->fails()) {
            $errorMessage = $validator->errors()->first();

            return "<html><body onload=\"alert('${errorMessage}')\"></body></html>";
        }

        // Get the file and try the upload
        $file = $request->file('fileImage');

        try {
            $image = (new WysiwygImage($project, $file))->save();

            // Return the link to the file
            $fileLink = '/'.config('image.prefix')."/{$image->name}";

            return "<html><body onload=\"parent.applyLargerImage('".$fileLink."')\"></body></html>";

        } catch (Exception $e) {
            return "<html><body onload=\"alert('Sorry, your file was not uploaded.')\"></body></html>";
        }
    }
}
