<?php

namespace Bongo\Project\Http\ViewComposers;

use Bongo\Project\Models\Project;
use Illuminate\View\View;

class RecentProjectsComposer
{
    public function compose(View $view): void
    {
        // Get the projects
        $projects = Project::active()->limit(2)->latest()->get();
        if (! $projects) {
            $projects = [];
        }

        // Pass the data to the view partial
        $view->with(compact('projects'));
    }
}
