<?php

namespace Bongo\Project\Listeners;

use Carbon\Carbon;
use Illuminate\Contracts\Queue\ShouldQueue;

class SetProjectDate implements ShouldQueue
{
    public int $tries = 3;

    public function handle($event): void
    {
        if (empty($event->project->date)) {
            $event->project->date = Carbon::now()->format('Y-m-d H:i:s');
            $event->project->save();
        }
    }
}
