<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('projects', 'schema')) {
            Schema::table('projects', function (Blueprint $table) {
                $table->mediumText('schema')
                    ->nullable()
                    ->after('js');
            });
        }
    }

    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn('schema');
        });
    }
};
