<?php

namespace Bongo\Project;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Menu\Listeners\ClearMenuCache;
use Bongo\Project\Events\ProjectCategoryDeleted;
use Bongo\Project\Events\ProjectCategoryUpdated;
use Bongo\Project\Events\ProjectCreated;
use Bongo\Project\Events\ProjectDeleted;
use Bongo\Project\Events\ProjectUpdated;
use Bongo\Project\Http\ViewComposers\ProjectCategoryComposer;
use Bongo\Project\Http\ViewComposers\ProjectComposer;
use Bongo\Project\Listeners\SetProjectDate;
use Bongo\Project\Listeners\SetProjectUser;
use Bongo\Project\Models\ProjectCategory;
use Bongo\Sitemap\Listeners\UpdateSitemap;
use Illuminate\Foundation\AliasLoader;

class ProjectServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'project';

    protected array $composers = [
        ProjectComposer::class => [
            'project::backend.partials.dropdowns.project',
        ],
        ProjectCategoryComposer::class => [
            'project::backend.category.partials.dropdowns.category',
        ],
    ];

    protected array $listeners = [
        ProjectCreated::class => [
            SetProjectDate::class,
            SetProjectUser::class,
        ],
        ProjectUpdated::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        ProjectDeleted::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        ProjectCategoryUpdated::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
        ProjectCategoryDeleted::class => [
            ClearMenuCache::class,
            UpdateSitemap::class,
        ],
    ];

    public function boot(): void
    {
        parent::boot();
        AliasLoader::getInstance()->alias('ProjectCategory', ProjectCategory::class);
    }
}
