@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $project->name }}
        @slot('actions')
            @linkButton(['name' => 'Project Builder','url' => route('frontend.project.edit', $project->uuid),'target' => '_blank'])
            @linkButton(['name' => trans('project::backend.show'),'url' => route('frontend.project.show', $project->slug),'target' => '_blank'])
            @linkButton(['name' => trans('project::backend.duplicate'),'url' => route('backend.project.duplicate', $project->id)])
            @deleteButton(['name' => trans('project::backend.delete'), 'url' => route('backend.project.destroy', $project->id)])
            @backButton(['name' => trans('project::backend.index'), 'url' => route('backend.project.index')])
            @editButton(['name' => trans('project::backend.edit'), 'url' => route('backend.project.edit', $project->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Name', 'value' => $project->name])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($project->status) ? ucwords($project->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Canonical Url', 'value' => $project->meta_canonical])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Indexing',
                                'value' => ! empty($project->meta_index) ? ucwords($project->meta_index) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Transparent Header',
                                'value' => ! empty($project->transparent_header) ? ucwords($project->transparent_header) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Allow Sticky Header',
                                'value' => ! empty($project->sticky_header) ? ucwords($project->sticky_header) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2 lg:grid-cols">
                        <div class="sm:col-span-1">
                            @static(['name' => 'Slug', 'value' => $project->slug])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Title', 'value' => $project->meta_title])
                        </div>
                        <div class="sm:col-span-1">
                            @static(['name' => 'Meta Description', 'value' => $project->meta_description])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @label(['name' => 'Categories'])
                            <div class="mt-1 text-sm leading-5 text-gray-900 {{ $class ?? '' }}">
                                @if (isset($project->categories) && count($project->categories))
                                    @foreach ($project->categories as $projectCategory)
                                        <span
                                            class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-100 text-gray-800"
                                        >
                                            {{ $projectCategory->name }}
                                        </span>
                                    @endforeach
                                @else
                                    -- --
                                @endif
                            </div>
                        </div>
                        <div class="sm:col-span-1">
                            @label(['name' => 'Cover / OG Image'])
                            <img
                                class="img-fluid mx-auto d-block w-100"
                                src="{{ $project->getPrimaryImage(['preset' => 'large']) }}"
                                alt="{{ $project->name }}"
                            />
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Summary', 'value' => $project->summary, 'isHtml' => true])
                @endcomponent
            </div>

            <div class="md:col-span-2">
                @if($project->isActive())
                    <preview url="{{ route('frontend.project.show', $project->slug) }}"></preview>
                @endif
            </div>
        </section>
    @endcomponent

@stop
