@extends('framework::frontend.layouts.app')

@section('body_class', 'web-editor')
@section('meta_title', 'Edit > '  . $project->name)
@section('page_title', 'Edit > '  . $project->name)
@section('breadcrumb', $project->name)
@php($version = setting('system::misc.version'))

@section('header_css')
    @parent
    <link href="{{ config('builder.backend_asset_path') }}/{{ config('builder.backend_css_file') }}?{{$version}}"
          rel="stylesheet" type="text/css"
    />
@endsection

@section('admin_menu_actions')
    <li class="nav-item text-success">
        Last Save: {{ ! empty($project->updated_at) ? $project->updated_at->format('d/m/Y H:i') : '-- --' }}
    </li>
    <li class="nav-item ml-4">
        <a href="{{ route('frontend.project.show', $project->slug) }}">
            <i class="fas fa-arrow-left text-4" style="top: 0;"></i>
            Back To Project
        </a>
    </li>
    <li class="nav-item ml-4">
        <button id="btnSave" type="button" class="btn btn-sm btn-success">
            SAVE CHANGES
        </button>
    </li>
@endsection

@section('content')
    <form id="form1" style="display:none" method="POST" action="{{ route('frontend.project.update', $project->uuid) }}">
        {{ csrf_field() }}
        <input type="hidden" id="inpHtml" name="html"/>
        <input type="submit" id="btnProject" value="submit"/>
    </form>

    <div id="post-builder" class="is-wrapper">
        @if(!empty($project->content))
            {!! $project->content !!}
        @else
            <div class="is-section is-box">
                <div class="is-boxes">
                    <div class="is-box-centered">
                        <div class="is-container is-builder container " style="max-width:800px">
                            <div class="row clearfix">
                                <div class="col">
                                    <h1>Lorem Ipsum is dummy text</h1>
                                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem
                                        Ipsum has
                                        been the industry's standard dummy text ever since the 1500s, when an unknown
                                        printer took a
                                        galley of type and scrambled it to make a type specimen book.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
@stop

@section('footer_javascript')
    <script defer src="{{ config('builder.vendor_asset_path') }}/jquery.js?{{$version}}" type="text/javascript"></script>
    <script defer src="{{ config('builder.vendor_asset_path') }}/owl.carousel.js?{{$version}}" type="text/javascript"></script>
    <script defer src="{{ config('builder.vendor_asset_path') }}/validation.js?{{$version}}" type="text/javascript"></script>

    <script defer src="{{ config('builder.backend_asset_path') }}/{{ config('builder.backend_js_file') }}?{{$version}}" type="text/javascript"></script>
    <script defer src="{{ config('builder.frontend_asset_path') }}/{{ config('builder.frontend_js_file') }}?{{$version}}" type="text/javascript"></script>

    <script defer type="text/javascript">

        // Snippet data
        function _path() {
            var scripts = document.querySelectorAll('script[src]');
            var currentScript = scripts[scripts.length - 1].src;
            var currentScriptChunks = currentScript.split('/');
            var currentScriptFile = currentScriptChunks[currentScriptChunks.length - 1];
            return currentScript.replace(currentScriptFile, '');
        }

        var _snippets_path = _path();
        var data_basic = {
            'snippets' : {!! Component::allAsJson() !!}
        };

        // Form input
        let unsavedChanges = false;
        let htmlInput = document.querySelector('#inpHtml');
        let btnSave = document.querySelector('#btnSave');
        let btnSubmit = document.querySelector('#btnProject');

        // Window has finished loading
        window.addEventListener('load', function (e) {

            // Create the editor
            jQuery(".is-wrapper").contentbox({
                apiPath : '{{ config('builder.api_path') }}',
                backendAssetPath : '{{ config('builder.backend_asset_path') }}',
                frontendAssetPath : '{{ config('builder.frontend_asset_path') }}',
                snippetCategories : {!! Component::categoriesAsJson() !!},
                largerImageHandler : '{{ route('frontend.project.image', $project->uuid) }}',
                coverImageHandler : '{{ route('frontend.project.background_image', $project->uuid) }}',
                onChange : function () {
                    htmlInput.value = jQuery(".is-wrapper").data('contentbox').html();
                    unsavedChanges = true;
                }
            });

            // Handle the save function
            btnSave.addEventListener('click', function () {
                htmlInput.value = jQuery(".is-wrapper").data('contentbox').html();
                unsavedChanges = false;
                btnSubmit.click();
            });

        }, false);

        // Check if the user has changed anything, before exiting
        window.addEventListener('beforeunload', function (e) {
            if (unsavedChanges) {
                const warning = 'Changes that you made may not be saved.';
                e.preventDefault();
                e.returnValue = warning;
                return warning;
            }
        });
    </script>
@endsection
