<?php

namespace Bongo\Project\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\CoverImage;
use Bongo\Project\Models\ProjectCategory;
use Exception;
use Illuminate\Http\JsonResponse;

class ProjectCategoryImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, ProjectCategory $projectCategory): JsonResponse
    {
        $files = request()->file('files');

        try {
            $projectCategory = (new CoverImage($projectCategory, $files[0]))->save();

            return response()->json([$projectCategory->getPrimaryImage(['preset' => 'thumb'])]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
