<?php

namespace Bongo\Project\Http\Requests;

use Bongo\Project\Models\Project;
use Illuminate\Foundation\Http\FormRequest;

class StoreProjectRequest extends FormRequest
{
    public function rules(): array
    {
        $projectTable = (new Project())->getTable();

        return [
            'name' => "required|unique:{$projectTable},slug,NULL,id,deleted_at,NULL|max:75",
        ];
    }
}
