<?php

namespace Bongo\Project\Http\Requests;

use Bongo\Project\Models\Project;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectRequest extends FormRequest
{
    public function rules(): array
    {
        $projectTable = (new Project())->getTable();

        return [
            'name' => "required|unique:{$projectTable},slug,{$this->project->id},id,deleted_at,NULL|max:75",
        ];
    }
}
