<?php

namespace Bongo\Project\Http\ViewComposers;

use Bongo\Project\Models\ProjectCategory;
use Illuminate\View\View;

class ProjectCategoryComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the project categories
        $projectCategories = ProjectCategory::active()->orderBy('name', 'ASC')->pluck('name', 'id');
        if (! $projectCategories) {
            $projectCategories = [];
        }

        // Pass the data to the view partial
        $view->with(compact('projectCategories'));
    }
}
