<?php

use Bongo\Project\Http\Controllers\Frontend\ProjectBackgroundImageController;
use Bongo\Project\Http\Controllers\Frontend\ProjectCategoryController;
use Bongo\Project\Http\Controllers\Frontend\ProjectController;
use Bongo\Project\Http\Controllers\Frontend\ProjectImageController;
use Illuminate\Support\Facades\Route;

// projects
Route::as('project.')
    ->prefix(config('project.prefix'))
    ->group(function () {

        // Builder
        Route::get('edit/{uuid}', [ProjectController::class, 'edit'])
            ->middleware(['auth', 'employee'])
            ->name('edit');

        Route::post('update/{uuid}', [ProjectController::class, 'update'])
            ->middleware(['auth', 'employee'])
            ->name('update');

        Route::post('image/{uuid}', [ProjectImageController::class, 'upload'])
            ->name('image');

        Route::post('background/{uuid}', [ProjectBackgroundImageController::class, 'upload'])
            ->name('background_image');

        // Public
        Route::get('{slug}', [ProjectController::class, 'show'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('show');

        Route::get('/', [ProjectController::class, 'index'])
            ->middleware(['hasRedirects', 'hasShortCodes', 'minifyHtml'])
            ->name('index');
    });

// project-categories
Route::as('project_category.')
    ->prefix(config('project.category_prefix'))
    ->group(function () {

        Route::get('{slug}', [ProjectCategoryController::class, 'show'])
            ->middleware(['hasRedirects', 'hasShortCodes'])
            ->name('show');

        Route::get('/', [ProjectCategoryController::class, 'index'])
            ->middleware(['hasRedirects', 'hasShortCodes'])
            ->name('index');
    });
