@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('project::backend.index') }}
        @slot('actions')
            @linkButton(['name' => 'Categories', 'url' => route('backend.project_category.index')])
            @backButton(['name' => trans('dashboard::backend.index')])
            @createButton(['name' => trans('project::backend.create'), 'url' => route('backend.project.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.project.datatable') }}"
            resource-url="{{ route('backend.project.index') }}"
            builder="/{{ config('project.prefix') }}/edit"
            order-by="date"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template
                slot="default"
                slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl, duplicateUrl, builderUrl}"
            >
                <div class="grid grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <div class="md:flex items-center">
                                <div class="mb-2 mr-3 lg:mb-0">
                                    <a :href="viewUrl(item)"
                                       class="flex m-0 md:m-auto lg:m-0 items-end h-16 w-16 rounded-full border-2 border-gray-200 bg-gray-100 hover:bg-gray-200"
                                    >
                                        <img :src="item.thumbnail" alt="avatar"
                                             class="inline-block h-16 w-16 h-16 rounded-full"
                                        >
                                    </a>
                                </div>
                                <div class="text-left">
                                    <a :href="viewUrl(item)" title="View"
                                       class="block font-semibold hover:text-primary-500 focus:text-primary-600"
                                    >
                                        @{{ item.name }}
                                    </a>
                                    <div v-if="item.status || item.date">
                                        <span class="text-sm">
                                            @{{ item.date | date }}
                                        </span>
                                        &nbsp;<span class="text-xs text-gray-400">|</span>&nbsp;
                                        <span
                                            :class="['text-sm', item.status === 'active' ? 'text-green-400' : 'text-red-500']"
                                        >
                                            @{{ item.status | ucwords }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </template>

                        <template slot="right">
                            <v-button :link="viewUrl(item)">View</v-button>
                            <v-button :link="editUrl(item)">Edit</v-button>
                            <v-button :link="builderUrl(item)" :target="'_blank'">Builder</v-button>
                        </template>
                    </v-card>

                </div>
            </template>
        </data-table>
    @endcomponent
@stop
