<section class="md:grid md:grid-cols-2 md:gap-6">

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $project->name,
                        'placeholder' => 'About Our Business',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $project->status,
                        'options' => get_enum_values('projects', 'status')
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'label' => 'Canonical Url',
                        'name' => 'meta_canonical',
                        'value' => $project->meta_canonical,
                        'placeholder' => url()->to('/') . '/about-our-business'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Indexing',
                        'name' => 'meta_index',
                        'value' => $project->meta_index,
                        'options' => [
                            'index' => 'Index Page',
                            'noindex' => 'Dont Index Page'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Transparent Header',
                        'name' => 'transparent_header',
                        'value' => $project->transparent_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'label' => 'Allow Sticky Header',
                        'name' => 'sticky_header',
                        'value' => $project->sticky_header,
                        'options' => [
                            'default' => 'Default',
                            'enabled' => 'Enabled',
                            'disabled' => 'Disabled'
                        ]
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                    'label' => 'Slug',
                    'name' => 'slug',
                    'value' => $project->slug,
                    'placeholder' => 'about-our-business',
                    'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                    'name' => 'meta_title',
                    'value' => $project->meta_title,
                    'placeholder' => 'About Our Business',
                    'maxlength' => 75,
                    ])
                </div>
                <div class="sm:col-span-2">
                    @textarea([
                    'name' => 'meta_description',
                    'value' => $project->meta_description,
                    'placeholder' => 'Everything you ever wanted to know about our business',
                    'maxlength' => 150,
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @include('project::backend.category.partials.dropdowns.category', ['model' => $project])
                </div>
                @if (!empty($project->id))
                    <div class="sm:col-span-1">
                        @label(['name' => 'Cover / OG Image'])
                        <file-uploader
                            class="mt-2"
                            url="{{ route('backend.project.image', $project->id) }}"
                            name="cover_image"
                            height="100"
                        ></file-uploader>
                    </div>
                @endif
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @wysiwyg(['name' => 'summary', 'value' => $project->summary, 'height' => 300, 'placeholder' => 'Enter summary
        text here...'])
    </div>

</section>

<css-editor css="{{ $project->css }}"></css-editor>
<js-editor js="{{ $project->js }}"></js-editor>
<schema-editor schema="{{ $project->schema }}"></schema-editor>
